<?php
class DashboardController extends Controller {
    public function admin() {
        session_start();
        if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
            header("Location: " . BASE_URL . "/LoginController/logout");
            exit;
        }

        $data = [
            'user' => $_SESSION['user_name']
        ];

        $this->view('dashboard/admin', $data);
    }

    public function agent() {
    session_start();

    if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'agent') {
        header("Location: " . BASE_URL . "/LoginController/logout");
        exit;
    }

    $taskModel = $this->model('Task');
    $userId = $_SESSION['user_id'];

    $data = [
        'user' => $_SESSION['user_name'],
        'pendingTasks' => $taskModel->countPendingTasks($userId),
        'dueToday' => $taskModel->countTasksDueToday($userId),
        'dueThisWeek' => $taskModel->countTasksDueThisWeek($userId)
    ];

    $this->view('dashboard/agent', $data);
}

}
