<?php 
class Interaction extends Model {
    public function getAllInteractions($userId, $role, $limit, $offset) {
    if ($role === 'admin') {
        $stmt = $this->db->prepare("
            SELECT i.*, u.name AS user_name, c.name AS contact_name
            FROM interactions i
            LEFT JOIN users u ON i.user_id = u.id
            LEFT JOIN contacts c ON i.contact_id = c.id
            ORDER BY i.interaction_date DESC
            LIMIT ? OFFSET ?
        ");
        $stmt->bindValue(1, $limit, PDO::PARAM_INT);
        $stmt->bindValue(2, $offset, PDO::PARAM_INT);
    } else {
        $stmt = $this->db->prepare("
            SELECT i.*, u.name AS user_name, c.name AS contact_name
            FROM interactions i
            LEFT JOIN users u ON i.user_id = u.id
            LEFT JOIN contacts c ON i.contact_id = c.id
            WHERE i.user_id = ?
            ORDER BY i.interaction_date DESC
            LIMIT ? OFFSET ?
        ");
        $stmt->bindValue(1, $userId, PDO::PARAM_INT);
        $stmt->bindValue(2, $limit, PDO::PARAM_INT);
        $stmt->bindValue(3, $offset, PDO::PARAM_INT);
    }

    $stmt->execute();
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

public function countAllInteractions($userId, $role) {
    if ($role === 'admin') {
        $stmt = $this->db->query("SELECT COUNT(*) FROM interactions");
    } else {
        $stmt = $this->db->prepare("SELECT COUNT(*) FROM interactions WHERE user_id = ?");
        $stmt->execute([$userId]);
    }
    return $stmt->fetchColumn();
}


    // Add interaction
    public function addInteraction($data) {
        $stmt = $this->db->prepare("
            INSERT INTO interactions (contact_id, user_id, type, summary, interaction_date)
            VALUES (:contact_id, :user_id, :type, :summary, :interaction_date)
        ");
        return $stmt->execute([
            'contact_id' => $data['contact_id'],
            'user_id' => $data['user_id'],
            'type' => $data['type'],
            'summary' => $data['summary'],
            'interaction_date' => $data['interaction_date']
        ]);
    }

    // Get interactions by contact ID
    // public function getInteractionsByContactId($contactId) {
    //     $stmt = $this->db->prepare("
    //         SELECT interactions.*, users.name AS author_name
    //         FROM interactions
    //         LEFT JOIN users ON interactions.user_id = users.id
    //         WHERE interactions.contact_id = ?
    //         ORDER BY interactions.interaction_date DESC
    //     ");
    //     $stmt->execute([$contactId]);
    //     return $stmt->fetchAll(PDO::FETCH_ASSOC);
    // }

    // Update interaction
    public function updateInteraction($interactionId, $userId, $data) {
        $stmt = $this->db->prepare("
            UPDATE interactions 
            SET type = :type, summary = :summary, interaction_date = :interaction_date, updated_at = NOW()
            WHERE id = :id AND user_id = :user_id
        ");
        return $stmt->execute([
            'type' => $data['type'],
            'summary' => $data['summary'],
            'interaction_date' => $data['interaction_date'],
            'id' => $interactionId,
            'user_id' => $userId
        ]);
    }

    // Delete interaction
    public function deleteInteraction($interactionId, $userId) {
        $stmt = $this->db->prepare("
            DELETE FROM interactions 
            WHERE id = ? AND user_id = ?
        ");
        return $stmt->execute([$interactionId, $userId]);
    }

    // Get a single interaction
    public function getInteractionById($interactionId) {
        $stmt = $this->db->prepare("
            SELECT interactions.*, users.name AS author_name
            FROM interactions
            LEFT JOIN users ON users.id = interactions.user_id
            WHERE interactions.id = ?
        ");
        $stmt->execute([$interactionId]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    
    public function getInteractionsByContactId($contactId) {
    $stmt = $this->db->prepare("
        SELECT i.*, u.name AS user_name
        FROM interactions i
        LEFT JOIN users u ON i.user_id = u.id
        WHERE i.contact_id = ?
        ORDER BY i.interaction_date DESC
    ");
    $stmt->execute([$contactId]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

}
?>
