<?php 
class Note extends Model {
    //add notes
    public function addNote($data) {
    $stmt = $this->db->prepare("
        INSERT INTO contact_notes (contact_id, user_id, content)
        VALUES (:contact_id, :user_id, :content)
    ");
    return $stmt->execute([
        'contact_id' => $data['contact_id'],
        'user_id' => $data['user_id'],
        'content' => $data['content']
    ]);
}

    //note by COntactID
 public function getNotesByContactId($contactId) {
    $stmt = $this->db->prepare("
        SELECT contact_notes.*, users.name AS author_name, contact_notes.user_id
        FROM contact_notes
        LEFT JOIN users ON contact_notes.user_id = users.id
        WHERE contact_notes.contact_id = ?
        ORDER BY contact_notes.created_at DESC
    ");
    $stmt->execute([$contactId]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}


    // Update note
public function updateNote($noteId, $userId, $content) {
    $stmt = $this->db->prepare("
        UPDATE contact_notes 
        SET content = ?, updated_at = NOW()
        WHERE id = ? AND user_id = ?
    ");
    return $stmt->execute([$content, $noteId, $userId]);
}

public function deleteNote($noteId, $userId) {
    $stmt = $this->db->prepare("
        DELETE FROM contact_notes 
        WHERE id = ? AND user_id = ?
    ");
    return $stmt->execute([$noteId, $userId]);
}

public function getNoteById($noteId) {
    $stmt = $this->db->prepare("
        SELECT n.*, u.name AS author_name
        FROM contact_notes n
        LEFT JOIN users u ON u.id = n.user_id
        WHERE n.id = ?
    ");
    $stmt->execute([$noteId]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

    
}

?>