<!-- Interactions Section -->
<div class="card mt-4">
    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
        <strong><i class="bi bi-chat-dots"></i> Interactions</strong>
        <button class="btn btn-light btn-sm" data-bs-toggle="collapse" data-bs-target="#interactionForm">➕</button>
    </div>

    <!-- Add Interaction Form -->
    <div class="collapse" id="interactionForm">
        <div class="card-body">
            <form action="<?= BASE_URL ?>/InteractionController/add/<?= $contact['id'] ?>" method="POST">
                <input type="hidden" name="contact_id" value="<?= $contact['id'] ?>">

                <div class="mb-2">
                    <label class="form-label">Interaction Type</label>
                    <select name="type" class="form-select" required>
                        <option value="">Select type</option>
                        <option value="Call">📞 Call</option>
                        <option value="Email">📧 Email</option>
                        <option value="Meeting">📅 Meeting</option>
                        <option value="Other">🔖 Other</option>
                    </select>
                </div>
                
                <div class="mb-2">
                    <label class="form-label">Interaction Date & Time</label>
                    <input type="datetime-local" name="interaction_date" class="form-control" required>
                </div>

                <div class="mb-2">
                    <label class="form-label">Summary</label>
                    <textarea name="summary" class="form-control" rows="3" required placeholder="Enter interaction summary..."></textarea>
                </div>

                

                <button type="submit" class="btn btn-success">💬 Add Interaction</button>
            </form>
        </div>
    </div>

    <!-- List of Interactions -->
    <div class="card-body">
        <?php if (!empty($interactions)): ?>
            <?php foreach ($interactions as $interaction): ?>
                <div class="border p-3 mb-2 rounded shadow-sm bg-light">
                    <small class="text-muted">
                        On <?= date('Y-m-d', strtotime($interaction['interaction_date'])) ?> |
                        Time: <?= date('H:i:s', strtotime($interaction['interaction_date'])) ?> |
                        Type: <strong><?= htmlspecialchars($interaction['type']) ?></strong> |
                        By: <em><?= htmlspecialchars($interaction['user_name']) ?></em>
                    </small>
                    <p class="mb-0 mt-2"><?= nl2br(htmlspecialchars($interaction['summary'])) ?></p>

                    <?php if ($_SESSION['user_id'] == $interaction['user_id']): ?>
                        <div class="mt-2 d-flex gap-2">
                            <a href="<?= BASE_URL ?>/InteractionController/edit/<?= $interaction['id'] ?>" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-pencil-square"></i> Edit
                            </a>
                            <a href="<?= BASE_URL ?>/InteractionController/delete/<?= $interaction['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this interaction?')">
                                <i class="bi bi-trash"></i> Delete
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-info">No interactions yet for this contact.</div>
        <?php endif; ?>
    </div>
</div>

<div class="mt-3">
    <a href="<?= BASE_URL ?>/contacts/" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back to Contacts
    </a>
</div>
