<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-warning text-dark">
            <h4 class="mb-0">✏️ Edit Interaction</h4>
        </div>
        <div class="card-body">
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="post" action="">
                <div class="mb-3">
                    <label class="form-label">Interaction Type</label>
                    <select class="form-select" name="type" required>
                        <?php
                        $types = ['Call', 'Email', 'Meeting', 'WhatsApp', 'Follow-Up'];
                        foreach ($types as $type) {
                            $selected = ($interaction['type'] === $type) ? 'selected' : '';
                            echo "<option value=\"$type\" $selected>$type</option>";
                        }
                        ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label">Date & Time</label>
                    <input type="datetime-local" name="interaction_date" class="form-control"
                        value="<?= date('Y-m-d\TH:i', strtotime($interaction['interaction_date'])) ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Summary</label>
                    <textarea name="summary" class="form-control" rows="4" required><?= htmlspecialchars($interaction['summary']) ?></textarea>
                </div>

                <button type="submit" class="btn btn-primary">Update Interaction</button>
                <a href="<?= BASE_URL ?>/interaction/index/<?= $interaction['contact_id'] ?>" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
