<div class="container mt-4">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="text-danger fw-bold">
            <i class="bi bi-exclamation-triangle-fill me-2"></i> Overdue Task Reminders
        </h2>
       <a href="<?= BASE_URL ?>/DashboardController/admin" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to Dashboard
        </a> 
    </div>

    <!-- Reminder Card -->
    <div class="card shadow-sm border-0 mb-4">
        <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">
                <i class="bi bi-bell-fill me-2"></i> Manual Reminder Sender
            </h5>
        </div>
        <div class="card-body">
            <p class="text-muted">
                Send email reminders to users with overdue tasks. Optionally CC other recipients (comma-separated).
            </p>

            <?php if (!empty($success)): ?>
                <div class="alert alert-success shadow-sm">
                    <i class="bi bi-check-circle-fill me-1"></i> <?= htmlspecialchars($success) ?>
                </div>
            <?php elseif (!empty($error)): ?>
                <div class="alert alert-danger shadow-sm">
                    <i class="bi bi-exclamation-octagon-fill me-1"></i> <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="post" action="<?= BASE_URL ?>/ReminderController/sendOverdueRemindersManual">
                <div class="mb-3">
                    <label for="cc_emails" class="form-label fw-semibold">CC Recipients</label>
                    <input type="text" name="cc_emails" id="cc_emails" class="form-control shadow-sm"
                           placeholder="e.g. manager@example.com, teamlead@example.com">
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-danger shadow-sm">
                        <i class="bi bi-send-check-fill me-1"></i> Send Reminders
                    </button>
                    <a href="<?= BASE_URL ?>/TaskController/index?status=overdue" class="btn btn-outline-dark shadow-sm">
                        <i class="bi bi-clock-history me-1"></i> View Overdue Tasks
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Overdue Task Preview -->
    
</div>
